//
// Created by strahinja on 3/13/24.
//

#include "OurCFG.h"

OurCFG::OurCFG(Function &F)
{
  FunctionName = F.getName().str();
  CreateCFG(F);
}

void OurCFG::CreateCFG(llvm::Function &F)
{
  for (const BasicBlock &BB : F) {
    AdjacencyList[&BB] = {};
    for (const BasicBlock *Successor : successors(&BB)) {
        AdjacencyList[&BB].push_back(Successor);
    }

//    for (auto &Instr : BB) {
//      if (const BranchInst *BranchInstr = dyn_cast<BranchInst>(&Instr)) {
//        AdjacencyList[&BB].push_back(BranchInstr->getSuccessor(0));
//        if (BranchInstr->isConditional()) {
//          AdjacencyList[&BB].push_back(BranchInstr->getSuccessor(1));
//        }
//      }
//    }
  }
}

void OurCFG::DumpToFile()
{
  std::error_code error;
  raw_fd_stream File("our" + FunctionName + ".dot", error);


  File << "digraph \"CFG for '" << FunctionName << "' function\" {\n";
  File << "\tlabel=\"Ovo je neki nas tekst\";\n\n";

  for (const auto &p : AdjacencyList) {
    DumpBasicBlock(p.first, File);
  }

  File << "}\n";
}

void OurCFG::DumpBasicBlock(const llvm::BasicBlock *Current, llvm::raw_fd_stream &File)
{
  bool hasMultipleSuccessors = false;

  File << "\tNode" << Current << " [shape=record,color=\"#b70d28ff\", style=filled, fillcolor=\"#b70d2870\",label=\"{";

  for (const Instruction &Instr : *Current) {
    if (Instr.isTerminator()) {
      if (const BranchInst *BrInstr = dyn_cast<BranchInst>(&Instr) && BrInstr->isConditional()) {
        hasMultipleSuccessors = true;
        File << Instr << "\\l|{<s0>True|<s1>False}}\"];\n";
      }
      else {
        File << Instr << "\\l}\"];\n";
      }
    }
    else {
      File << Instr << "\\l ";
    }
  }

  int successorNum = 0;
  for (const BasicBlock *Successor : AdjacencyList[Current]) {
    if (hasMultipleSuccessors) {
      File << "\tNode" << Current << ":s" << successorNum++ << " -> Node" << Successor << ";\n";
    }
    else {
      File << "\tNode" << Current << " -> Node" << Successor << ";\n";
    }
  }
}