//
// Created by strahinja on 3/13/24.
//

#ifndef LLVM_PROJECT_OURCFG_H
#define LLVM_PROJECT_OURCFG_H

#include "llvm/IR/Function.h"
#include "llvm/IR/Instruction.h"
#include "llvm/IR/Instructions.h"
#include <unordered_map>
#include <vector>

using namespace llvm;

class OurCFG {
private:
  std::string FunctionName;
  std::unordered_map<const BasicBlock *, std::vector<const BasicBlock *>> AdjacencyList;
  void CreateCFG(Function &F);
  void DumpBasicBlock(const BasicBlock *, raw_fd_stream &);
public:
  OurCFG(Function &F);
  void DumpToFile();
};

#endif // LLVM_PROJECT_OURCFG_H
