#include "llvm/Pass.h"
#include "llvm/IR/Function.h"
#include "llvm/Support/raw_ostream.h"
#include "OurCFG.h"

using namespace llvm;

namespace {
struct OurCFGPass : public FunctionPass {
  static char ID;
  OurCFGPass() : FunctionPass(ID) {}

  bool runOnFunction(Function &F) override {
    OurCFG *CFG = new OurCFG(F);
    CFG->DumpToFile();

    delete CFG;
    return false;
  }
}; // end of struct Hello
}  // end of anonymous namespace

char OurCFGPass::ID = 0;
static RegisterPass<OurCFGPass> X("hello", "Hello World Pass",
                             false /* Only looks at CFG */,
                             false /* Analysis Pass */);