//
// Created by strahinja on 4/3/24.
//

#include "ConstantPropagationInstruction.h"

using namespace llvm;

ConstantPropagationInstruction::ConstantPropagationInstruction(Instruction *Instr)
{
  this->Instr = Instr;
}

void ConstantPropagationInstruction::setStatusAfter(Value *Variable, Status S, int value)
{
  StatusAfter[Variable] = {S, value};
}

void ConstantPropagationInstruction::setStatusBefore(Value *Variable, Status S, int value)
{
  StatusBefore[Variable] = {S, value};
}

void ConstantPropagationInstruction::addPredecessor(ConstantPropagationInstruction *Predecessor)
{
  Predecessors.push_back(Predecessor);
}

llvm::Instruction *ConstantPropagationInstruction::getInstruction()
{
  return Instr;
}

void ConstantPropagationInstruction::addVariables(const std::vector<Value *> &Variables)
{
  for (Value *Variable : Variables) {
    setStatusBefore(Variable, Bottom);
    setStatusAfter(Variable, Bottom);
  }
}