import sys
import re

if len(sys.argv) != 2:
    print("Args")
    sys.exit()

if re.match(r"^.*\.html$", sys.argv[1], re.I) is None:
    print("Ekstenzija")
    sys.exit()

try:
    with open(sys.argv[1],"r") as f:
        data = f.read()
except IOError:
    print("file ne postoji")
    sys.exit()

ri = re.compile(r"<tr>"
+ r"\s*<td>\s*(?P<ime>[A-Z][a-z]+(\s+[A-Z][a-z]+)+)\s*</td>"
+ r"\s*<td>\s*(?P<prakticni>0|[1-9]|[1-9][0-9]|100)\s*</td>\s*"
+ r"\s*<td>\s*(?P<usmeni>0|[1-9]|[1-9][0-9]|100)\s*</td>\s*"
+r"</tr>", re.S)

studenti = []
poeni = []

for m in ri.finditer(data):
    print("Ime: ",  m.group("ime"))
    print("\tUsmeni: ",  m.group("usmeni"))
    print("\tPrakticni: ", m.group("prakticni"))

    studenti.append(m.group("ime"))
    p = int(m.group("usmeni")) + int(m.group("prakticni"))
    #p /= 2
    poeni.append(p)

parovi = sorted(zip(poeni, studenti))
parovi.reverse()

for p, s in parovi:
    print(s, p)

