import sys
import re
import os

if len(sys.argv) != 3:
    sys.exit(arg)

if re.match(r"^.*\.txt$", sys.argv[1], re.I) is None:
    sys.args("ext")

homedir = sys.argv[2]

studenti = {}
filePath = os.path.join(homedir, sys.argv[1])
re_linija = re.compile("^(?P<indeks>(m[mnvrlia]|a[aif])([01][0-9]|2[0-3])(00[1-9]|0[1-9]\d|[1-4]\d\d|500))\s*,\s*(?P<ime>[A-Z][a-z]+(\s+[A-Z][a-z]+)+)$", re.I));
try:
    with open(filePath, "r") as f:
        for l in f:
            if l[-1] == "\n":
                l = l[:-1]
            
            m = re_linija.match(l)
            if m is not None:
                ime = m.group("ime")
                indeks = m.group("indeks")

                studenti[indeks] = ime
except IOError:
    sys.exit("open")

re_dir = re.compile(r"^(m[mnvrlia]|a[aif])([01][0-9]|2[0-3])(00[1-9]|0[1-9]\d|[1-4]\d\d|500)$", re.I)
re_file = re.compile(r"^(?P<broj>\d+)\.(?P<ext>c|cpp|java)$", re.I)

maxZad = 0
zadaci = {}

for f in os.listdir(homedir):
    dirPath = os.path.join(homedir, f)
    m = re_dir.match(f)
    if os.path.isdir(dirPath) and m is not None:
        for sf in os.listdir(dirPath):
            filePath = os.path.join(dirPath, sf)
            m1 = re_file.match(sf)
            if os.path.isfile(filePath) and m1 is not None:
                
                int zad = int(m1.group("broj"))
                zadaci[(f, zad)] = m1.group("ext")

                if zad > maxZad:
                    maxZad = zad

for indeks, ime in studenti.items():
    print(ime, indeks, sep=", ")
    for i in range(1, maxZad):
        if zadaci.get((indeks, i)) is not None:
            print("\t" + str(i) + ". " + zadaci[(indeks, i)])
        else:
            print("\t" + str(i) + ". /")