import sys
import re

if len(sys.argv) != 3:
    sys.exit("args")

if re.match(r"^.*\.xml$", sys.argv[1], re.I) is None:
    sys.exit("file1")

if re.match(r"^.*\.xml$", sys.argv[2], re.I) is None:
    sys.exit("file2")

try: 
    with open(sys.argv[1],"r") as f:
        data_smestaj = f.read()

    with open(sys.argv[2],"r") as f:
        data_rezervacije = f.read()
except IOError:
    sys.exit("open")

ri_smestaj = re.compile(
r'<smestaj\s+rbr\s*=\s*"(?P<rbr>[0-9]+)"\s*>\s*'
+r"(?=.*?<tip>\s*(?P<tip>hotel|apartman)\s*</tip>)"
+r"(?=.*?<zemlja>(?P<zemlja>[A-Za-z ]+)\.(?P<mesto>[A-Za-z ]+)\.(?P<hotel>[A-Za-z0-9 ]+)</zemlja>)"
+r"(?=.*?<usluga>\s*(?P<usluga>Najam|ND|Polupansion|PP|All inclusive)\s*</usluga>)"
+r"(?=.*?<broj_soba>\s*(?P<broj_soba>[0-9]+)(?P<balkon>(b|s){0,2})\s*</broj_soba>)"
+r"(?=.*?<kapacitet>(?P<kap>[0-9]+)</kapacitet>)"
+r"(?=.*?<max_kapacitet>(?P<mkap>[0-9]+)</max_kapacitet>)"
+r"(?=.*?<gratis>(?P<gratis>da|ne)(?P<deca>(\.[0-9]+)?)</gratis>)"
+r"(?=.*?<cena>(?P<cena>[0-9]+)</cena>)"
+r"(?=.*?<zakup>(?P<zakup>[0-9]+)</zakup>)"
+r".*?"
+r"</smestaj>", re.S)

smestaji = {}

for m in ri_smestaj.finditer(data_smestaj):
    rbr = m.group("rbr")
    tip = m.group("tip")
    zemlja = m.group("zemlja")
    mesto = m.group("mesto")
    hotel = m.group("hotel")
    usluga = m.group("usluga")
    broj_soba = m.group("broj_soba")
    balkon = m.group("balkon")
    if balkon == "ss" or balkon == "bb":
        continue
    if "s" in balkon:
        pogledaNaMore = "pogled na more" 
    else: 
        pogledaNaMore = "bez pogleda na more" 
    if "b" in balkon:
        balkon = "sa balkonom"
    else: 
        balkon = "bez balkona"
    kapacitet = m.group("kap")
    max_kapacitet = m.group("mkap")
    gratis = m.group("gratis")
    deca = m.group("deca")
    cena = m.group("cena")
    zakup = m.group("zakup")
    
    smestaji[rbr] = [zemlja, mesto, hotel,usluga]

rezervacije = {}

ri_rezervacije = re.compile(
r'<rezervacija\s+rbr\s*=\s*"(?P<rbr>[0-9]+)"\s*>\s*'
+r"(?=.*?<smestaj>\s*(?P<smestaj>[0-9]+)\s*</smestaj>)"
+r"(?=.*?<ime>\s*(?P<ime>[A-Za-z ]+)\s*</ime>)"
+r"(?=.*?<gosti>\s*(?P<gosti>[0-9]+)\s*</gosti>)"
+r"(?=.*?<deca>\s*(?P<deca>[0-9]+)\s*</deca>)"
+r"(?=.*?<trajanje>\s*(?P<trajanje>[0-9]+)\s*</trajanje>)"
+r"(?=.*?<cena>\s*(?P<cena>[0-9]+)\s*</cena>)"
+r".*?"
+r"</rezervacija>"
,re.S)

for m in ri_rezervacije.finditer(data_rezervacije):
    rbr = m.group("rbr")
    smestajId = m.group("smestaj")
    ime = m.group("ime")
    if rezervacije.get(smestajId) is None:
        rezervacije[smestajId] = [rbr, ime]
    else:
        rezervacije[smestajId].append([rbr, ime])

for k,v in smestaji.items():
    if rezervacije.get(k) is None:
        print("Ne postoji rezervacija")
    else:
        print(v[0], v[1], v[2])
        lista = rezervacije[k]
        for r in lista:
            print("\t", r)