import sys
import re

if len(sys.argv) < 2:
    sys.exit("args")

if re.match(r"^.*\.xml$", sys.argv[1], re.I) is None:
    sys.exit("ext")

try:
    with open(sys.argv[1], "r") as f:
        data = f.read()
except IOError:
    sys.exit("open")

ri_knjiga = re.compile(r'<knjiga\s+rbr\s*=\s*"(?P<rbr>[0-9]+)"\s*>\s*'
+r"(?=.*?<naslov>\s*(?P<naslov>.*?)\s*</naslov>\s*)"
+r"(?=.*?<autor>\s*(?P<autor>[A-Z][a-z]*(\s+[A-Z][a-z]*)+)\s*</autor>\s*)"
+r"(?=.*?<god>\s*(?P<god>(19\d\d|20([01]\d|2[0-3])))\s*</god>)"
+r"(?=.*?<izdavac>\s*(?P<izdavac>.*?)\s*</izdavac>)"
+r'(?=.*?<cena\s+valuta\s*=\s*"(?P<valuta>[a-z]{3})"\s*>\s*(?P<iznos>[0-9]+)\s*</cena>)'
+r".*?"
+r"</knjiga>", re.S)

knjige = {}

for m in ri_knjiga.finditer(data):
    rbr = m.group("rbr")
    naslov = m.group("naslov")
    autor = m.group("autor")
    god = int(m.group("god"))
    izdavac = m.group("izdavac")
    valuta = m.group("valuta")
    cena = int(m.group("iznos"))
    knjige[rbr] = [naslov, autor, god, izdavac, valuta, cena]

if len(sys.argv) == 2:
    for k,v in knjige.items():
        print(k, ":", v)

god = False
godV = -1
autor = False
autorV = ""
izdavac = False
izdavacV = ""

k = 0;
for c in sys.argv[2]:
    if k == 0 and c != "-":
        sys.exit("opt")
        k+=1
    else:
        if c == "a":
            autor = True
            autorV = sys.argv[k]
        elif c == "g":
            godina = True
            godV = int(sys.argv[k])
        elif c == "i":
            izdavac = True
            izdavacV = sys.argv[k]
        k+=1

for k,v in knjige.items():
    stampaj = True
    if autor and v[1] != autorV:
        stampaj = False
    if god and v[2] != godV:
        stampaj = False
    if izdavac and v[3] != izdavacV:
        stampaj = False
    if stampaj:
        print(k, ":", v)