import sys
import re

if len(sys.argv) != 3:
    sys.exit("args")

if re.match(r"^.*\.xml$", sys.argv[1], re.I) is None:
    sys.exit("ext")

if re.match(r"^.*\.xml$", sys.argv[2], re.I) is None:
    sys.exit("ext")

if sys.argv[2] == sys.argv[1]:
    sys.exit("files")

try:
    with open(sys.argv[1], "r") as f:
        data_s = f.read()
    with open(sys.argv[2], "r") as f:
        data_r = f.read()
except IOError:
    sys.exit("open")

smestaji = {}
rezervacije = {}

ri_s = re.compile(
r'<smestaj\s+rbr\s*=\s*"\s*(?P<rbr>[0-9]+)\s*"\s*>'+
r"(?=.*?<tip>\s*(?P<tip>apartman|hotel)\s*</tip>)"+
r"(?=.*?<zemlja>(?P<zemlja>[A-Za-z ]+)\.(?P<mesto>[A-Za-z ]+)\.(?P<hotel>.*?)</zemlja>)"+
r"(?=.*?<usluga>\s*(NA|ND|HB|FB|AL)\s*</usluga>)"+
r"(?=.*?<broj_soba>\s*(?P<sobe>[0-9]+)(?P<balkon>(b|s|bs)?)?\s*</broj_soba>)"+
r"(?=.*?<kapacitet>\s*(?P<kap>[0-9]+)\s*</kapacitet>)"+
r"(?=.*?<max_kapacitet>\s*(?P<maxk>[0-9]+)</max_kapacitet>)"+
r"(?=.*?<gratis>\s*(?P<gratis>((da\.[0-9]+)|ne))\s*</gratis>)"+
r"(?=.*?<cena>\s*(?P<cena>[0-9]+)\s*</cena>)"+
r"(?=.*?<zakup>\s*(?P<zakup>[0-9]+)\s*</zakup>)"+
r".*?"
r"</smestaj>"
, re.S)

for m in ri_s.finditer(data_s):
    rbr = m.group("rbr")
    zemlja = m.group("zemlja")
    mesto = m.group("mesto")
    hotel = m.group("hotel")

    smestaji[rbr] = [zemlja, mesto, hotel]

ri_r = re.compile(
r'<rezervacija\s+rbr\s*=\s*"\s*(?P<rbr>[0-9]+)\s*"\s*>'+
r"(?=.*?<smestaj>\s*(?P<smestaj>[0-9]+)\s*</smestaj>)"+
r"(?=.*?<ime>\s*(?P<ime>[A-Za-z ]+)\s*</ime>)"+
r"(?=.*?<gosti>\s*(?P<gosti>[0-9]+)\s*</gosti>)"+
r"(?=.*?<deca>\s*(?P<deca>[0-9]+)\s*</deca>)"+
r"(?=.*?<max_kapacitet>\s*(?P<maxk>[0-9]+)</max_kapacitet>)"+
r"(?=.*?<trajanje>\s*(?P<trajanje>[0-9]+)\s*</trajanje>)"+
r"(?=.*?<cena>\s*(?P<cena>[0-9]+)\s*</cena>)"+
r".*?"
r"</rezervacija>"
,re.S)

for m in ri_r.finditer(data_r):
    smestaj = m.group("smestaj")
    rbr = m.group("rbr")
    ime = m.group("ime")
    trajanje = m.group("trajanje")
    cena = m.group("cena")

    if rezervacije.get(smestaj) is None:
        rezervacije[smestaj] = [[rbr, ime, trajanje, cena]]
    else:
        rezervacije[smestaj].append([rbr, ime, trajanje, cena])

for k, v in smestaji.items():
    print(k,v)
    if rezervacije.get(k) is None:
        print("\t /")
    else:
        putnici = rezervacije[k]
        for l in putnici:
            print("\t", l)
