import sys
import re

if len(sys.argv) != 2:
    sys.exit("args")

if re.match(r"^.*\.txt$", sys.argv[1], re.I) is None:
    sys.exit("ext")

try:
    with open(sys.argv[1], "r") as f:
        data = f.read()
except IOError:
    sys.exit("open")

ri_ucenik = re.compile(
r"(?P<mb>MB[0-9A-Z]{10})\s*;"+
r"\s*(?P<ime>[A-Z][a-z]+(\s+[A-Z][a-z]+)+)\s*;"+
r"\s*(?P<pol>M|Z)\s*;"+
r"\s*o(?P<opravdani>[0-9]+)n(?P<neopravdani>[0-9]+)nap(?P<nap>[0-9]+)\s*;"+
r"\s*(?P<ocene>[1-5](\s*,\s*[1-5]){9})"
)

ucenici = {}

for m in ri_ucenik.finditer(data):
    mb = m.group("mb")
    ime = m.group("ime")
    pol = m.group("pol")
    opravdani = int(m.group("opravdani"))
    neopravdani = int(m.group("neopravdani"))
    napomene = int(m.group("nap"))
    ocene = list(map(int, m.group("ocene").split(",")))
    vladanje = 5
    vladanje -= neopravdani/6
    vladanje -= napomene/2
    if vladanje <= 0:
        vladanje = 1
    prosek = vladanje
    for i in range(0, len(ocene)):
        prosek += ocene[i]
    prosek /= (len(ocene) + 1)

    ucenici[mb] = [ime, pol, prosek]

proseci = []
ucenicil = []
for k,v in ucenici.items():
    proseci.append(v[2])
    ucenicil.append(v)

parovi = sorted(zip(proseci, ucenicil))
parovi.reverse()

for p, v in parovi:
    print(v)




