%option noyywrap

%{

int brojZagrada = 0;
%}

%%

"(" { brojZagrada++; }
")" { 
        if (brojZagrada <= 0) {
            return -1;
        }    
        brojZagrada--;
    }
.   {
        ECHO; // ispisi na izlaz ono sto si prepoznao
    }
\n  {
        ECHO;
    }

%%

int main() {

    int retVal = yylex();

    if (retVal == -1) { /* desila se greska */
        printf("Zagrade nisu uparene\n");
    }
    else { /* greska */
        if (brojZagrada == 0)
            printf("Pravilno uparene\n");
        else
            printf("Nisu pravilno uparene\n");
    }

    exit(EXIT_SUCCESS);
}