%option noyywrap

%x comment

%{
    int brojLinija = 0;    
%}

%%

"/*"    { BEGIN(comment); }
<comment>[^*\n]* { }
<comment>[*]*    { }
<comment>\n     {brojLinija++;}
<comment>\*+"/"   { BEGIN(INITIAL); }
\n      { ECHO; brojLinija++; }
.       {ECHO; }

%%

int main() {

    yylex();

    printf("Broj linija: %d\n", brojLinija);

    exit(EXIT_SUCCESS);
}