%option noyywrap

%{

#define I_CONST (1)
#define F_CONST (2) 
#define PREPROC_DIR (3)
#define KEYWORD     (4)
#define ID          (5)
#define SEP         (6)
#define TERM        (7)
#define OZ          (8)
#define ZZ          (9)
#define OB          (10)
#define ZB          (11)
#define A_OP        (12)
#define R_OP        (13)
#define DODELA      (14)
#define GRESKA      (15)
#define STRING      (16)

void stampajString(char* s);
void stampajChar(char c);

%}

%x comment

DIGIT   [0-9]

%%

#.*$    { 
            fprintf(yyout,"<span style=\"color:violet;\">");
                stampajString(yytext);
            fprintf(yyout,"</span>");
        }
int|double|float|short|char|if|else|for|while|extern|return     { 
                    fprintf(yyout,"<span style=\"color:blue;\">");
                    ECHO; 
                    fprintf(yyout,"</span>");
        }
[a-zA-Z_][a-zA-Z0-9_]*  {ECHO;}
,       {ECHO; }
;       {ECHO; }
"("     {ECHO; }
")"     {ECHO; }
"{"     {ECHO; }
"}"     {ECHO; }
"<="    {stampajString(yytext); }
">="    {stampajString(yytext); }
"="     {ECHO; }
"++"    {ECHO; }
"--"    {ECHO; }
"\""[^"]*"\"" {
                    fprintf(yyout,"<span style=\"color:blue;\">");
                    stampajString(yytext);
                    fprintf(yyout,"</span>");
            }
[+*/%-] {ECHO; }
[<>]    {stampajString(yytext); } 
[+-]?{DIGIT}+       {
                        fprintf(yyout,"<span style=\"color:green;\">");
                        ECHO; 
                        fprintf(yyout,"</span>");
               
                    }
[+-]?{DIGIT}+\.{DIGIT}*([Ee][+-]?{DIGIT}+)? {
                        fprintf(yyout,"<span style=\"color:green;\">");
                        ECHO; 
                        fprintf(yyout,"</span>");
               
               
                    }
"//".*$             { 
                        fprintf(yyout,"<span style=\"color:grey;\">");
                        stampajString(yytext);; 
                        fprintf(yyout,"</span>");
               
                    }
"/*"                { BEGIN(comment); 
                        fprintf(yyout,"<span style=\"color:grey;\">");
                        ECHO; 
                    }
<comment>[^*\n]*    { stampajString(yytext);}
<comment>[*]*       { stampajString(yytext);}
<comment>\n         { stampajString(yytext);}
<comment>\*+"/"     { BEGIN(INITIAL); 
                        stampajString(yytext);
                      fprintf(yyout,"</span>");
                    }
[ \n\t\\]             { stampajString(yytext); }
.                   { 
                        fprintf(yyout, "Leksicka greska\n");
                        return GRESKA;
                     }

%%

void stampajString(char* s) {
    int i = 0;
    for (i = 0; s[i] != 0; i++)
        stampajChar(s[i]);
}
void stampajChar(char c){

    switch (c) {
        case '\n':
            fprintf(yyout, "<br>");
            break;
        case '&':
            fprintf(yyout, "&amp");
            break;
        case ' ':
            fprintf(yyout, "&nbsp");
            break;
        case '<':
            fprintf(yyout, "&lt");
            break;
        case '>':
            fprintf(yyout, "&gt");
            break;
        default:
            fprintf(yyout, "%c", c);
            break;
    }
}

int main(int argc, char** argv) {

    if (argc >= 2) {
        yyin = fopen(argv[1], "r");
        if (yyin == NULL)
            exit(EXIT_FAILURE);
    }
    else {
        yyin = stdin;
        yyout = stdout;
    }
    if (argc >= 3) {
        yyout = fopen(argv[2], "w");
        if (yyout == NULL)
            exit(EXIT_FAILURE);
    }
    else {
        yyout = stdout;
    }

    fprintf(yyout, "<html><head><title>%s</title></head><body>", argv[2]);

    yylex();

    fprintf(yyout, "</body></html>");

    if (yyin != stdin)
        fclose(yyin);
    if (yyout != stdout)
        fclose(yyout);


    exit(EXIT_SUCCESS);
}