%option noyywrap

%{
    int broj_linija = 0;    
%}

%x COMMENT

%%

"/*"    { BEGIN(COMMENT);}
<COMMENT>[^*\n]     { }
<COMMENT>"*"*       { }
<COMMENT>\n         {broj_linija++;}
<COMMENT>\*+"/"     {BEGIN(INITIAL);}    
\n {ECHO; broj_linija++;}
.  {ECHO; } 


%%

int main() {

    yylex();

    printf("Broj linija: %d\n", broj_linija);

    exit(EXIT_SUCCESS);
}