#ifndef POLY_V1
#define POLY_V1

/* Klasa Polinom ce interno da koristi dinamicki niz za 
 * za cuvanje liste koeficijenata 
 */
#include <iostream>
#include <cstdlib>
#include <cmath>
#include "DinamickiNiz.h"

class Polinom_v1
{
private:
	/* Koristimo ranije napisanu klasu DinamickiNiz za reprezentaciju
	 * koeficijenata polinoma. Indeks u nizu odgovara stepenu promenljive
	 * uz koju se koeficijent nalazi. 
	 * 
	 * Primetimo da je klasa DinamickiNiz dizajnirana tako da ispunjava RAII 
	 * koncept, sto znaci da mozemo da je koristimo kao obicnu automatsku 
	 * promenljivu. Dakle, klasa DinamickiNiz sama vodi racuna o svojim resursima
	 * i mi o tome ne moramo uopste da vodimo racuna, tj. ne moramo da razmisljamo
	 * o alokaciji/dealokaciji memorije i upravljanju resursima, vec mozemo da je 
	 * koristimo kao bilo koju automatsku promenljivu (poput int,double ...)
	 * 
	 * Dodatno, klasa DinamickiNiz ispunjava RAII zahteva, pa u klasi Polinom mozemo
	 * da se oslonimo da ce podrazumevano obezbedjeni konstruktor kopije, operator 
	 * dodele i destruktor ispravno raditi. Atribut tipa DinamickiNiz je zbog toga
	 * ekvivalentan prostim tipovima i ne moramo da pisemo eksplicitne implementacije 
	 * velike trojke, sto i necemo ciniti. 
	 * 
	 * BITNO:
	 * Oslanjanje na podrazumevane kosntruktor kopije, operator dodele i destruktor sme
	 * da se radi samo kada klasa kao atribute ima podatke prostih ili RAII tipova. Ako
	 * klasa koristi dinamicke resurse eksplicitno (tj. one koji nisu enkapsulirani u neki
	 * RAII tip) ili koristi klase za koje ne postoji garancija da su RAII, na korisniku je 
	 * da obezbedi eksplicitne implementacije velike trojke i da na ispravan nacin eksplicitno
	 * upravlja resursima. 
	 */
	DinamickiNiz _koeficijenti;
	/* pomocna funkcija koja uklanja vodece nule uz najvisi stepen */
	void normalizuj();
public:
	Polinom_v1();			// podrazumevani kostruktor
	Polinom_v1(int n);		// polinom stepena n inicijalizovan nulama
	
	int stepen() const;		// stepen polinom

	void show(std::ostream& s) const;

	void dodajKoef(double koef);
	
	// aritmeticki operatori
	Polinom_v1 operator +(const Polinom_v1& p) const;
	Polinom_v1 operator -(const Polinom_v1& p) const;
	Polinom_v1 operator *(const Polinom_v1& p) const;
	Polinom_v1 operator -() const;

	// indeksiranje
	double& operator [](int i);
	const double& operator [](int i) const;

	// izracunavanje vrednosti u tacki
	double operator[](double x);

	// uporedjivanje
	bool operator ==(const Polinom_v1& p) const;
	bool operator !=(const Polinom_v1& p) const;

	// operatori dodeljivanja
	Polinom_v1& operator +=(const Polinom_v1& p);
	Polinom_v1& operator -=(const Polinom_v1& p);
	Polinom_v1& operator *=(const Polinom_v1& p);
};

/* globalni operator za stampanje polinoma */
std::ostream& operator <<(std::ostream& s, const Polinom_v1& p);

#endif