#ifndef MATRIX_H
#define MATRIX_H

#include <iostream>
#include <iomanip>
#include <vector>

/* Klasa implementira tip podataka matrica */
class Matrix {
private:
    /* Radi jednostavnosti, matricu predstavljamo kao vektor vektora. 
     * Implementacija sa vektorima je izuzetno laka, jer je saglasna sa
     * nacinom na koji izgradjujemo matricu. 
     * Matricu izradjujemo vrstu po vrstu, dok svaku vrstu izgradjujemo broj po broj.
     * Bas zbog ovakvog pristupa, prirodno je da vrsta bude predstavljena vektorom,
     * a matrica vektorom vektora. 
     */
    std::vector<std::vector<double>> _mat;
    /* druga opcija je predstaviti matricu kao double** i uvesti dodatne dve 
     * promenljive za pamcenje broja vrsta i kolona. Takva implementacija
     * bi zahtevala implementaciju kontruktora kopije, operatora dodele i 
     * destruktora, sto bez potrebe komplikuje klasu.
     * Pored toga, ovakva implementacija nije saglasna sa izgradjivanjem matrice
     * vrstu po vrstu, pa bi zahtevala prilicno koda za odrzavanje stanja same matrice. 
     */
public:
    /* potrebni konstruktori */
    Matrix();
    Matrix(int m, int n, double val = 0);
    Matrix(Matrix* m);

    void dodajRed(std::vector<double>& red);
    void show(std::ostream& s) const;

    /* pomocne metode za izracunavanje dimenzija matrice */
    int Rows() const;
    int Columns() const;
    std::pair<int, int> Size() const;

    /* operator indeksiranja
     * matrica je vektor vektora, pa operator indeksiranja nad matricom
     * treba samo da vrati referencu na red koji korisnik zeli. drugi indeks
     * ce zapravo biti indeks nad vektor kolonom.
     */
    std::vector<double>& operator[](int i);
    const std::vector<double>& operator[](int i) const;

    /* aritmeticki operatori */
    Matrix* operator +(const Matrix& m) const;
    Matrix* operator -(const Matrix& m) const;
    Matrix* operator *(const Matrix& m) const;

    Matrix* operator -() const;

    /* ostatak operacija je predstavljen metodama  */
    Matrix* Transponuj() const;
    Matrix* Pomnozi(const Matrix& m) const;
    Matrix* Podeli(const Matrix& m) const;

    /* metod za izdvajanje podmatrice. jedna ideja 
     * za implementaciju je da koristimo parove za definisanje
     * intervala po redovima i kolonama. 
     */
    Matrix* SubMatrix(std::pair<int, int>& rows, std::pair<int, int>& cols);

    /* operatori poredjenja */
    bool operator ==(const Matrix& m) const;
    bool operator !=(const Matrix& m) const;
};

/* operator za stampanje */
std::ostream& operator <<(std::ostream& s, const Matrix& m);

#endif