#ifndef POLINOM_H
#define POLINOM_H

#include <iostream>
#include <vector>
#include <cmath>

/* pomocna klasa za reprezentaciju polinoma */
class Polinom {
private:
    /* koeficijente cuvamo u vektoru u rastucem redosledu,
     * tj. indeks koeficijenta odgovara stepenu promenljive x
     * uz koju stoji koeficijent
     */
    std::vector<double> _koef;
    /* pomocni metod koji uklanja vodece nule */
    void normalizuj(); 
public:
    Polinom();
    Polinom(int n);
    /* prilagodjeni konstruktor kopije. sve vreme koristimo objekte na hipu
     * i u gramatici koristimo pokazivace, pa je logicno i da kopiju pravimo
     * na osnovu pokazivaca na neki polinom objekat
     */
    Polinom(Polinom* p);

    /* metod doddaje novi koeficijent na kraj vektora */
    void dodajKoef(double val);
    int stepen() const;
    void show(std::ostream& s) const;

    /* racunanje vrednosti polinoma u tacki */
    double operator [](double x);

    /* svi operatori kreiraju rezultate  na hipu 
     * i kao rezultat vracaju pokazivace 
     */
    Polinom* operator +(const Polinom& p) const;
    Polinom* operator -(const Polinom& p) const;
    Polinom* operator *(const Polinom& p) const;
    
    Polinom* operator -() const;

    Polinom* izvod() const;
    Polinom* integral(double c) const;

    bool operator ==(const Polinom& p) const;
    bool operator !=(const Polinom& p) const;
};

std::ostream& operator <<(std::ostream& s, const Polinom& p);

#endif
