%option noyywrap

%{
    #include <iostream>
    #include <cstdlib>

    #include "SymbolTable.hpp"
    #include "SyntaxTree.hpp"
    #include "parser.tab.hpp"
%}

%%

def     {return DEF_T;}
print   {return PRINT_T;}
%[bdh]  {
            yylval.c = yytext[1];
            return FMT_T;
        }
[A-Za-z_][A-Za-z0-9]*  {   
            yylval.s = new std::string(yytext);
            return ID_T;
        }
[0-9]+  {
            yylval.d = atoi(yytext);
            return BROJ_T;
        }
"=="    {return EQ_T;}
"!="    {return NEQ_T;}
"<="    {return LEQ_T;}
">="    {return GEQ_T;}
"<<"    {return SHL_T;}
">>"    {return SHR_T;}
[+*/%()<>=,;^|&~"-]  {return *yytext;}
[ \t\n] { }
.       {
            std::cerr << "Leksicka greska: " << (*yytext) << std::endl;
            exit(EXIT_FAILURE);
        }


%%