#include "graph.hpp"

Graph::Graph()
    : _max(0), _graph(), _undirected(), _directed() {

}
Graph::Graph(const Graph& g)
    : _max(g._max), _graph(), _undirected(), _directed() {

    for (auto& kv : g._graph) {
        std::vector<int>* edges = new std::vector<int>();
        for (int i = 0; i < kv.second->size(); i++) {
            edges->push_back(kv.second->at(i));
        }
        _graph[kv.first] = edges;
    }

    BuildMatrixRep();
}
Graph::~Graph() {

    for (auto& kv : _graph)
        delete kv.second;
}

Graph& Graph::operator =(const Graph& g) {
    
    if (this == &g)
        return *this;
    
    for (auto& kv : _graph) {
        delete kv.second;
    }
    
    _graph.clear();
    _directed.clear();
    _undirected.clear();
    _max = g._max;

    for (auto& kv : g._graph) {
        std::vector<int>* edges = new std::vector<int>();
        for (int i = 0; i < kv.second->size(); i++) {
            edges->push_back(kv.second->at(i));
        }
        _graph[kv.first] = edges;
    }

    BuildMatrixRep();

    return *this;
}

void Graph::AddNode(int nodeNum, std::vector<int>* edges) {

    auto it = _graph.find(nodeNum);

    if (it != _graph.end())
        throw std::invalid_argument("cvor vec definisan");

    _graph[nodeNum] = edges;
    if (nodeNum > _max)
        _max = nodeNum;
}

void Graph::DropNode(int nodeNum) {

    auto it = _graph.find(nodeNum);

    if (it == _graph.end())
        throw std::invalid_argument("cvor ne postoji");
    std::vector<int> nodes;
    for (auto& kv : _graph) {
        delete kv.second;
        nodes.push_back(kv.first);
    }
    
    _graph.clear();
    _max = 0;

    for (int i = 0; i < _directed.size(); i++) {
        
        if (i == nodeNum - 1)
            continue;

        int newNodeNum = i + 1;
        std::vector<int>* edges = new std::vector<int>();
        for (int j = 0; j < _directed[i].size(); j++) {
            if (_directed[i][j] == 1 && j != nodeNum - 1)
                edges->push_back(j + 1);
        }

        if (std::find(nodes.begin(), nodes.end(), newNodeNum) != nodes.end())
            this->AddNode(newNodeNum, edges);
    }

    BuildMatrixRep();
}

Graph* Graph::Clone() {
    return new Graph(*this);
}
    
Graph* Graph::operator +(const Graph& g) const {
    Graph* result = new Graph();

    int newSize = std::max(_max, g._max);

    std::vector<std::vector<int>> g_res(newSize, std::vector<int>(newSize, 0));

    for (int i = 0; i < _directed.size(); i++) {
        for (int j = 0; j < _directed[i].size(); j++) {
            if (_directed[i][j] == 1)
                g_res[i][j] = 1;
        }
    }

    for (int i = 0; i < g._directed.size(); i++) {
        for (int j = 0; j < g._directed[i].size(); j++) {
            if (g._directed[i][j] == 1)
                g_res[i][j] = 1;
        }
    }

    for (int i = 0; i < g_res.size(); i++) {
        int nodeNum = i + 1;
        std::vector<int>* edges = new std::vector<int>();
        for (int j = 0; j < g_res[i].size(); j++) {
            if (g_res[i][j] == 1)
                edges->push_back(j + 1);
        }

        if (edges->size() > 0)
            result->AddNode(nodeNum, edges);
    }

    return result;
}
Graph* Graph::operator *(const Graph& g) const {
    Graph* result = new Graph();

    int newSize = std::min(_max, g._max);

    std::vector<std::vector<int>> g_res(newSize, std::vector<int>(newSize, 0));

    for (int i = 0; i < newSize; i++) {
        for (int j = 0; j < newSize; j++) {
            if (_directed[i][j] == 1 && g._directed[i][j] == 1)
                g_res[i][j] = 1;
        }
    }

    for (int i = 0; i < g_res.size(); i++) {
        int nodeNum = i + 1;
        std::vector<int>* edges = new std::vector<int>();
        for (int j = 0; j < g_res[i].size(); j++) {
            if (g_res[i][j] == 1)
                edges->push_back(j + 1);
        }

        if (edges->size() > 0)
            result->AddNode(nodeNum, edges);
    }

    return result;
}
    
Graph* Graph::operator ~() const {

    Graph* result = new Graph();

    for (int i = 0; i < _directed.size(); i++) {
        int nodeNum = i + 1;
        std::vector<int>* edges = new std::vector<int>();
        for (int j = 0; j < _directed[i].size(); j++) {
            if (_directed[i][j] == 0)
                edges->push_back(j + 1);
        }

        if (edges->size() > 0)
            result->AddNode(nodeNum, edges);
    }
    

    return result;
}

std::vector<int>* Graph::at(int index) {

    if (index < 0)
        throw std::invalid_argument("cvor ne postoji");

    auto it = _graph.find(index);

    if (it == _graph.end())
        throw std::invalid_argument("cvor ne postoji");

    return it->second;
}

std::vector<std::vector<int>>& Graph::Directed() {
    return _directed;
}
std::vector<std::vector<int>>& Graph::Undirected() {
    return _undirected;
}

void Graph::BuildMatrixRep() {

    _directed.clear();
    _undirected.clear();

    _directed.resize(_max, std::vector<int>(_max, 0));
    _undirected.resize(_max, std::vector<int>(_max, 0));

    for (auto& kv : _graph) {
        for (auto it = kv.second->begin(); it != kv.second->end(); it++) {
            _directed[kv.first-1][(*it) - 1] = 1;
            _undirected[kv.first-1][(*it) - 1] = 1;
            _undirected[(*it) - 1][kv.first-1] = 1;
        }
    }
}

void Graph::show(std::ostream& s) const {
    for (auto& kv : _graph) {
        s << kv.first << " : [";
        for (auto it = kv.second->begin(); it != kv.second->end(); it++) {
            if (it != kv.second->begin())
                s << ", ";
            s << (*it);
        }
        s << "]" << std::endl;
    }
}

std::ostream& operator <<(std::ostream& s, const Graph& g) {

    g.show(s);
    return s;
}

std::ostream& operator <<(std::ostream& s, const std::vector<std::vector<int>>& mat) {
    for (int i = 0; i < mat.size(); i++) {
        for (int j = 0; j < mat.at(i).size(); j++) {
            s << mat.at(i).at(j) << " ";
        }
        s << std::endl;
    }
    return s;
}