%option noyywrap

%{
    #include <iostream>
    #include <cstdlib>
    #include <vector>
    #include <map>
    #include <algorithm>
    #include "graph.hpp"

    #include "parser.tab.hpp"
%}

%%
begin   {return BEGIN_T;}
end     {return END_T;}
graph   {return GRAPH_T;}
print_matrix_d  {return P_MAT_D;}
print_matrix_u  {return P_MAT_U;}
print   {return PRINT_T;}
delete  {return DEL_T;}
[a-zA_Z][A_Za-z0-9_]*   {   
                            yylval.s = new std::string(yytext);
                            return ID_T;
                        }
[0-9]+  {
            yylval.v = atoi(yytext);
            return BROJ_T;
        }
"["     {return *yytext;}
"]"     {return *yytext;}
"{"     {return *yytext;}
"}"     {return *yytext;}
[+*();:,=~]      { return *yytext; }
[ \n\t] { }
.   {
        std::cerr << "Leksicka greska: " << (*yytext) << std::endl;
        exit(EXIT_FAILURE);
    }
%%