#include "types.hpp"

std::ostream& operator <<(std::ostream& s, const Type* t) {
    t->show(s);
    return s;
}
BoolType::BoolType(bool v)
    : _value(v) {

}

bool BoolType::GetBool() const{

    return _value;
}
int BoolType::GetInt() const{

    return _value ? 1 : 0;
}
std::string BoolType::GetString() const{

    return _value ? "True" : "False";
}
Skup BoolType::GetSkup() const{

    return _value ? Skup(1)  : Skup(0);
}
Type* BoolType::Clone() const{

    return new BoolType(*this);
}
void BoolType::show(std::ostream& s) const{

    s << (_value ? "True" : "False");
}

IntType::IntType(int v)
    : _value(v) {

}

bool IntType::GetBool() const{

    return _value != 0;
}

int IntType::GetInt() const {
    return _value;
}
std::string IntType::GetString() const {
    return std::to_string(_value);
}
Skup IntType::GetSkup() const {

    return Skup(_value);
}
Type* IntType::Clone() const {
    return new IntType(*this);
}
void IntType::show(std::ostream& s) const {

    s << _value;
}

StringType::StringType(const std::string& v)
    : _value(v) {

}

bool StringType::GetBool() const{

    return _value.size() > 0;
}

int StringType::GetInt() const {
    return _value.size();
}
std::string StringType::GetString() const {
    return _value;
}
Skup StringType::GetSkup() const {

    return Skup();
}

Type* StringType::Clone() const {
    return new StringType(*this);
}

void StringType::show(std::ostream& s) const {

    s << _value;
}

SkupType::SkupType(const Skup& s)
    : _value(s) {

    }
SkupType::SkupType(const SkupType& st)
    : _value(st._value) {

    }

bool SkupType::GetBool() const{

    return _value.Size() != 0;
}

int SkupType::GetInt() const{

    return _value.Size();
}
std::string SkupType::GetString() const{

    std::string result;
    std::stringstream ss(result);
    _value.show(ss);
    return ss.str();
}
Skup SkupType::GetSkup() const{

    return _value;
}
Type* SkupType::Clone() const{

    return new SkupType(*this);
}
void SkupType::show(std::ostream& s) const{

    s << _value;
}

void SkupType::Dodaj(int v) {

    _value.Dodaj(v);
}