#ifndef __NAREDBA__HPP__
#define __NAREDBA__HPP__

#include "Izraz.hpp"
#include <vector>
using namespace std;

class Naredba{
	public:
		virtual ~Naredba(){}
		virtual Naredba* Clone() const=0;
		virtual void izvrsiSe() const = 0;
};

class PrintN: public Naredba{
	public:
		~PrintN();
		Naredba* Clone() const;
		PrintN(Izraz* oper1):op1(oper1){}
		void izvrsiSe() const;
	private:
		Izraz* op1;	
};

class LogicN: public Naredba{
	public:
		~LogicN();
		Naredba* Clone() const;
		LogicN(LIzraz* oper1):op1(oper1){}
		void izvrsiSe() const;
	private:
		LIzraz* op1;	
};

class DefinitionN: public Naredba{
	public:
		~DefinitionN();
		Naredba* Clone() const;
		DefinitionN(string im, Izraz* oper1): ime(im), op1(oper1){}
		void izvrsiSe() const;
	private:
		string ime;
		Izraz* op1;
};

class IfN: public Naredba{
	public:
		~IfN();
		Naredba* Clone() const;
		IfN(LIzraz * u, Naredba* n1,  Naredba* n2): uslov(u), naredbe1(n1), naredbe2(n2){}
		void izvrsiSe() const;
	private:
		LIzraz * uslov;
		Naredba* naredbe1;
		Naredba* naredbe2;
		
};

class NizNaredbi: public Naredba{
	public:
		~NizNaredbi();	
		NizNaredbi& operator = (const NizNaredbi& n);
		void dodajNaredbu(Naredba* n);
		Naredba* Clone() const;
		NizNaredbi(std::vector<Naredba*> n):naredbe(n){}
		void izvrsiSe() const;
		
	public:
		std::vector<Naredba*> naredbe;
};

#endif
